
#define PATH_TRACK	"PathTrack"

class PathTrack
{
public:
	PathTrack(LPCSTR lpcszDialog, int nMaxPathNum = 10)///Jake 06/18/07 V8.0643 NEED_TO_LIMITED_PATH_NUMBER
	{
		m_strDlg = lpcszDialog;
		m_nMaxPathNum = nMaxPathNum;
		bool bRet = dlg_load_registry(m_strDlg, PATH_TRACK, m_strPaths);
	}
	~PathTrack()
	{
		bool bRet = Save();
	}
	string Load()
	{
		return m_strPaths;
	}
	bool Save()
	{
		bool bRet;
		if(m_bUpdate && dlg_save_to_registry(m_strDlg, PATH_TRACK, m_strPaths))
		{
			m_bUpdate = false;
			return true;
		}
		return false;
	}
	bool Add(LPCSTR lpcszPath)
	{
		vector<string> vsPath;
		if(m_strPaths.IsEmpty())
		{
			m_strPaths = lpcszPath;
			m_bUpdate = true;//mark and save change to registry when destroy
			return true;
		}
		m_strPaths.GetTokens(vsPath, '|');
		int nFind = vsPath.Find(lpcszPath);
		if(!nFind)//=0, no need update
			return false;
		m_bUpdate = true;
		if(nFind > 0)
			vsPath.RemoveAt(nFind);
		vsPath.InsertAt(0, lpcszPath);
		///Jake 06/18/07 V8.0643 NEED_TO_LIMITED_PATH_NUMBER
		if(vsPath.GetSize() > m_nMaxPathNum)
		{
			vsPath.RemoveAt(vsPath.GetSize() -1);
		}
		///end NEED_TO_LIMITED_PATH_NUMBER
		m_strPaths.SetTokens(vsPath, '|');
		return true;
	}
private:
	string	m_strDlg;
	string 	m_strPaths;
	bool 	m_bUpdate;
	int		m_nMaxPathNum;///Jake 06/18/07 V8.0643 NEED_TO_LIMITED_PATH_NUMBER
};

//void test_pt()
//{
	//PathTrack myPathTrack("abc");
	//string str = myPathTrack.Load();
	//ool bRet = myPathTrack.Add("MyPath");
	//
//}
